﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


//
//  An example of how to call the Vaunix LMS DLL from C#
//

namespace LMS_Demo
{
    class Program
    {
        static void Main(string[] args)
        {
            int m_NumberOfDevices = 0;
            UInt32 i;
            int status;
            int Frequency;
            int MinFrequency = 0;
            int MaxFrequency = 0;
            float TmpFreqInHz;
       
            Console.WriteLine("C# LMS Demo Program");

            LMSWrapper.SetTestMode(false);
            m_NumberOfDevices = LMSWrapper.GetNumberOfDevices();    // look for devices

            Console.WriteLine("Found " + m_NumberOfDevices.ToString() + " Devices");

            if (m_NumberOfDevices != 0)
            {
                // fill in the table of device IDs
                LMSWrapper.GetDevInfo();

                // open all the Lab Bricks we found, 0 based array...
                for (i = 0; i < m_NumberOfDevices; i++)
                {
                    LMSWrapper.InitDevice(i);
                }

                // do whatever we want with them, lets start by displaying some information about the devices
                for (i = 0; i < m_NumberOfDevices; i++)
                {
                    Console.WriteLine(LMSWrapper.GetModelName(i));

                    // Let's show the current frequency of the LMS device

                    status = LMSWrapper.GetFrequency(i);

                    if (status > 0)
                    {
                        TmpFreqInHz = (float)status / 100000000;   // scale from 10Hz units to GHz
                        Console.WriteLine("Frequency = {0:G} GHz", TmpFreqInHz);
                    }
                    else
                    {
                        // we got an error of some sort, print it out
                        Console.WriteLine("SetFrequency returned error code {0:X}", status);
                    }

                    // And then we will set the frequency to 1/3 of the way from the minimum to the maximum
                    status = LMSWrapper.GetMinFreq(i);

                    if (status > 0)
                    {
                        MinFrequency = status;
                        TmpFreqInHz = (float)status / 100000000;   // scale from 10Hz units to GHz
                        Console.WriteLine(" Minimum Frequency = {0:G} GHz", TmpFreqInHz);
                    }
                    else
                    {
                        // we got an error of some sort, print it out
                        Console.WriteLine("GetMinFreq returned error code {0:X}", status);
                    }
                    status = LMSWrapper.GetMaxFreq(i);

                    if (status > 0)
                    {
                        MaxFrequency = status;
                        TmpFreqInHz = (float)status / 100000000;   // scale from 10Hz units to GHz
                        Console.WriteLine(" Maximum Frequency = {0:G} GHz", TmpFreqInHz);
                    }
                    else
                    {
                        // we got an error of some sort, print it out
                        Console.WriteLine("GetMaxFreq returned error code {0:X}", status);
                    }

                    if (MinFrequency > 0 && MaxFrequency > 0)
                    {
                        Frequency = MinFrequency + (MaxFrequency - MinFrequency) / 3;
                        status = LMSWrapper.SetFrequency(i, Frequency);

                        if (status < 0)
                        {
                            // we got an error of some sort, print it out
                            Console.WriteLine("SetFrequency returned error code {0:X}", status);
                        }
                    }

                }

                // close all the Lab Bricks we used, 0 based array...
                for (i = 0; i < m_NumberOfDevices; i++)
                {
                    LMSWrapper.CloseDevice(i);
                }

            }

            // Keep the console window open in debug mode.
            Console.WriteLine("Press any key to exit.");
            Console.ReadKey();

        }
    }
}
